 ; FIRST.CMD - FIRST TIME COMMAND FILE TO CREATE SETUP.CMD
 ; RSX11M FPS100 FEB 80
 ;
 .ENABLE SUBSTITUTION
 .SETS $LUIC "[1,1]"     .; THE SYSTEM LIBRARY UIC IS ...
 .SETS $WUIC "[100,100]" .; THE WORK UIC IS ...
 ;
 .MM0:
 .ASKS $MM0 WHAT IS THE MAGTAPE DEVICE NAME?
 .;
 .; BEGIN ERROR CHECKING
 .;
 .IF <STRLEN> < 2 .OR .IF <STRLEN> > 4  .GOTO MM0
 .IF <STRLEN> = 2   .SETS $MM0 $MM0+"0"
 .SETS S $MM0[3:3]
 .IF S = ":"  .SETS $MM0 $MM0[1:2]+"0"
 .SETS S $MM0[3:3]
 .IF S < "0" .OR .IF S > "9"   .GOTO MM0
 .SETS S $MM0[1:2]
 .IF S <> "MM" .IF S <> "MT" .IF S <> "MS"  .GOTO MM0
 .;
 .; END ERROR CHECKING
 .;
 .SETS $MM0 $MM0[1:3]+":"
 .SETS $MM $MM0[1:2]+":"
 ;
 .ASK ANS IS THE INSTALLATION TAPE 800 BPI
 .IFF ANS .SETN $BPI 0
 ;
 ASN =
 ASN LB:=SY:
;
 .SETS $LBDSK <SYDISK>+"'<SYUNIT>'"+":"
 .ASK ANS IS '$LBDSK' THE SYSTEM DISK
 .IFF ANS .ASKS $LBDSK ENTER SYSTEM DISK NAME:
 .SETS S "0"
 .IF <SYDISK> = "DK" .IF <SYUNIT> = 0  .SETS S "1"
 .IF <SYDISK> = "DL" .IF <SYUNIT> = 0  .SETS S "1"
 .SETS $WKDSK <SYDISK>+S+":"
 ;
 .ASK ANS IS '$WKDSK' THE WORK DISK
 .IFF ANS .ASKS $WKDSK ENTER WORK DISK NAME:
;
ASN '$WKDSK'=SY:
SET /UIC='$WUIC'
;
 ;
 ; OPEN SETUP.CMD
 ;
 .OPEN SETUP.CMD
 .DATA .ENABLE SUBSTITUTION
 .DATA .ENABLE GLOBAL
 .DATA .SETS $MM "'$MM'"
 .DATA .SETS $MM0 "'$MM0'"
 .IFNDF $BPI .DATA .SETS $BPI "0"
 .IFDF $BPI .DATA .SETS $BPI "1"
 .DATA .SETS $LBDSK "'$LBDSK'"
 .DATA .SETS $WKDSK "'$WKDSK'"
 .DATA .SETS $LUIC "'$LUIC'"
 .DATA .SETS $WUIC "'$WUIC'"
 ;
 .ASK ANS ARE BASIC MATH LIBRARIES INCLUDED
 .IFT ANS .DATA .SETN $BASLB 0
 ;
 .ASK ANS ARE TMR LIBRARIES INCLUDED
 .IFT ANS .DATA .SETN $TMR 0
 ;
 .ASK ANS ARE SIGNAL PROCESSING LIBRARIES INCLUDED
 .IFT ANS .DATA .SETN $SIG 0
 ;
 .ASK ANS ARE IMAGE PROCESSING LIBRARIES INCLUDED
 .IFT ANS .DATA .SETN $IPR 0
 ;
 .ASK ANS ARE ADVANCED MATH LIBRARIES INCLUDED
 .IFT ANS .DATA .SETN $AML 0
 ;
 .ASK ANS IS PROGRAM DEVELOPMENT SOFTWARE (PDS) INCLUDED
 .IFT ANS .DATA .SETN $PDS 0
 ;
 .ASK ANS IS THE SUPER-100 SUPERVISOR INCLUDED
 .IFT ANS .DATA .SETN $SUP10 0
 ;
 .ASK ANS IS THE MINI-100 SUPERVISOR INCLUDED
 .IFT ANS .DATA .SETN $MIN10 0
 ;
 .DATA  SET /BUF=TI:80.
 .DATA .;
 .DATA .; GET A TASK BUILDER...
 .DATA .;
 .DATA .IFINS TKB .GOTO 100
 .DATA INS $BIGTKB/INC=10000/TASK=...TKB
 .DATA .IFINS TKB .GOTO 100
 .DATA INS $TKB/INC=10000/TASK=...TKB
 .DATA .IFINS TKB .GOTO 100
 .DATA ; BIGTKB OR TKB CANNOT BE FOUND !!!  INSTALL ONE BEFORE RESUMING.
 .DATA .PAUSE
 .DATA .;
 .DATA .; GET AN ASSEMBLER...
 .DATA .;
 .DATA .100: .IFINS MAC .GOTO 110
 .DATA INS $BIGMAC/INC=10000/TASK=...MAC
 .DATA .IFINS MAC .GOTO 110
 .DATA INS $MAC/INC=10000/TASK=...MAC
 .DATA .IFINS MAC .GOTO 110
 .DATA ; BIGMAC OR MAC CANNOT BE FOUND !!!  INSTALL ONE BEFORE RESUMING.
 .DATA .PAUSE
 .DATA .;
 .DATA .; GET A FORTRAN COMPILER. F4P WILL BE USED IF INSTALLED.
 .DATA .; FORCE RE-INSTALLATION WITH LOTS OF MEMORY
 .DATA .;
 .DATA .110: .IFINS F4P .GOTO 120
 .DATA .IFINS FOR REM FOR
 .DATA INS $FOR/INC=37000
 .DATA .IFINS FOR  .GOTO 130
 .DATA .120: .IFINS F4P  REM F4P
 .DATA INS $F4P/INC=44000
 .DATA .IFINS F4P  .GOTO 130
 .DATA ; F4P OR FOR CANNOT BE FOUND !!!  INSTALL ONE BEFORE RESUMING.
 .DATA .PAUSE
 .DATA .;
 .DATA .; GET THE LIBRARIAN, PIP, AND AN EDITOR.
 .DATA .; (EDT WILL BE USED IF IT IS INSTALLED)
 .DATA .;
 .DATA .130: .IFINS LBR .GOTO 150
 .DATA INS $LBR/TASK=...LBR
 .DATA .IFINS LBR .GOTO 150
 .DATA ; LBR CANNOT BE FOUND !!! INSTALL IT BEFORE RESUMING.
 .DATA .PAUSE
 .DATA .150: .IFINS PIP .GOTO 160
 .DATA INS $PIP
 .DATA .IFINS PIP .GOTO 160
 .DATA ; PIP CANNOT BE FOUND !!! INSTALL IT BEFORE RESUMING.
 .DATA .PAUSE
 .DATA .160: .IFINS EDI .GOTO 170
 .DATA .IFINS EDT .GOTO 170
 .DATA INS $EDI/INC=40000/TASK=...EDI
 .DATA .170:
 .DATA .;
 .DATA .; SET UP THE SWITCHES FOR COMPILING.
 .DATA .;
 .DATA .SETS $F4P0 ""
 .DATA .SETS $F4P2 "/CO:99./-TR/-I4"
 .DATA .SETS $F4P1 $F4P2
 .DATA .;
 .DATA .SETS $FOR2 "/-I4/-SN"
 .DATA .SETS $FOR1 $FOR2+"/-VA"
 .DATA .;
 .DATA .SETS $COM "N"   .; DO NOT SAVE FORTRAN COMMENTS ON MAGTAP READS.
 .DATA .SETN $NOAP 1   .; ONE AP IS BEING CONNECTED.
 .DATA ASN '$LBDSK'=LB:
 .DATA .IFNLOA '$MM'  LOA '$MM'
 .DATA ASN '$WKDSK'=SY:
 .DATA SET /UIC='$WUIC'
 .DATA ;
 .DATA ; *** THE LAST NUMBER IN THE RESPONSE HERE SHOULD BE AT LEAST 400.
 .DATA SET /POOL
 .DATA ; *** (IF NOT, MAY DIE.)
 .DATA ; END SETUP
 .DATA .EXIT
 ; END OF FIRST TIME FILE.
 .EXIT
